/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.mobevent;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.gui.GuiOverlay;
import com.lycanitesmobs.core.mobevent.MobEventBase;
import com.lycanitesmobs.core.mobevent.MobEventBoss;
import com.lycanitesmobs.core.mobevent.MobEventServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class MobEventClient {
    public MobEventBase mobEvent;
    public int ticks = 0;
    public World world;
    public PositionedSoundRecord sound;
    public boolean extended = false;

    public MobEventClient(MobEventBase mobEvent, World world) {
        this.mobEvent = mobEvent;
        this.world = world;
        if (!world.field_72995_K) {
            LycanitesMobs.printWarning("", "Created a MobEventClient with a server side world, this shouldn't happen, things are going to get weird!");
        }
    }

    public void onStart(EntityPlayer player) {
        String eventMessage = I18n.func_74838_a((String)("event." + (this.extended ? "extended" : "started")));
        eventMessage = eventMessage.replace("%event%", this.mobEvent.getTitle());
        player.func_145747_a((ITextComponent)new TextComponentString(eventMessage));
        if (!player.field_71075_bZ.field_75098_d || MobEventServer.testOnCreative || this.mobEvent instanceof MobEventBoss) {
            this.playSound();
        }
    }

    public void playSound() {
        if (AssetManager.getSound("mobevent_" + this.mobEvent.name.toLowerCase()) == null) {
            LycanitesMobs.printWarning("MobEvent", "Sound missing for: " + this.mobEvent.getTitle());
            return;
        }
        this.sound = new PositionedSoundRecord(AssetManager.getSound("mobevent_" + this.mobEvent.name.toLowerCase()).func_187503_a(), SoundCategory.RECORDS, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.sound);
    }

    public void onFinish(EntityPlayer player) {
        String eventMessage = I18n.func_74838_a((String)"event.finished");
        eventMessage = eventMessage.replace("%event%", this.mobEvent.getTitle());
        player.func_145747_a((ITextComponent)new TextComponentString(eventMessage));
    }

    public void onUpdate() {
        ++this.ticks;
    }

    @SideOnly(value=Side.CLIENT)
    public void onGUIUpdate(GuiOverlay gui, int sWidth, int sHeight) {
        EntityPlayer player = LycanitesMobs.proxy.getClientPlayer();
        if (player.field_71075_bZ.field_75098_d && !MobEventServer.testOnCreative && !(this.mobEvent instanceof MobEventBoss)) {
            return;
        }
        if (this.world == null || this.world != player.func_130014_f_()) {
            return;
        }
        if (!this.world.field_72995_K) {
            return;
        }
        int introTime = 240;
        if (this.ticks > introTime) {
            return;
        }
        int startTime = 40;
        int stopTime = 80;
        float animation = 1.0f;
        if (this.ticks < startTime) {
            animation = (float)this.ticks / (float)startTime;
        } else if (this.ticks > introTime - stopTime) {
            animation = (float)(introTime - this.ticks) / (float)stopTime;
        }
        int width = 256;
        int height = 256;
        int x = sWidth / 2 - width / 2;
        int y = sHeight / 2 - height / 2;
        int u = width;
        int v = height;
        gui.mc.func_110434_K().func_110577_a(this.getTexture());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)animation);
        gui.func_73729_b(x += 3 - this.ticks % 6, y += 2 - this.ticks % 4, u, v, width, height);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture() {
        if (AssetManager.getTexture("guimobevent" + this.mobEvent.name) == null) {
            AssetManager.addTexture("guimobevent" + this.mobEvent.name, this.mobEvent.group, "textures/mobevents/" + this.mobEvent.name.toLowerCase() + ".png");
        }
        return AssetManager.getTexture("guimobevent" + this.mobEvent.name);
    }
}

